<?php
    /**
    *
    * copyright (c) 2015-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    */

    class GestoreFileCsv {
        private $percorso;
        private $separatore;
        private $rigaCorrente;
        private $numeroRighe;
        private $numeroColonne;
        private $righeFile;
        
        public function __construct($percorso,$separatore, $intestazione=true) {
            $this->percorso   = $percorso;
            $this->separatore = $separatore;
            if($intestazione) {
                $this->rigaCorrente = 1;
            }
            else {
                $this->rigaCorrente = 0;
            }
            if(file_exists($percorso)) {
                $this->righeFile     = file($percorso);
                $this->numeroRighe   = count($this->righeFile);
                $this->numeroColonne = count(str_getcsv($this->righeFile[0],$this->separatore));
            }
            else {
                $this->righeFile   = [];
                $this->numeroRighe = 0;
                $this->numeroColonne = 0;
            }
        }
        
        /*
         * metodo che consente di aggiungere una riga nel file csv
         * il parametro $posizione è opzionale, se non viene inserito la riga
         * verrà posta alla fine del file, altrimenti viene inserito nella posizione
         * passata in input e tutte le righe successive vengono spostate in avanti
         * di una posizione
         */
        function aggiungiRiga($riga, $posizione = -1) {
            if($posizione == -1) {
                $this->righeFile[$this->numeroRighe] = $riga;
                $this->numeroRighe++;
            }
            else {
                $tmp = $riga;
                for($i = $posizione; $i<$this->numeroRighe; $i++) {
                    $this->righeFile[$posizione] = $tmp;
                    $tmp = $this->righeFile[$posizione];
                }
                $this->numeroRighe++;
            }
        }
        
        /*
         * Metodo per salvare il file
         * Se viene passato il parametro $nomeFile verrà creato un file con quel nome,
         * altrimenti sovrascrive il file esistente
         */
        function salva($nomeFile = "") {
            if($nomeFile=="") {
                $file = fopen($this->percorso, "w");
            }
            else {
                $file = fopen($nomeFile, "w");
            }
            foreach($this->righeFile as $singolaRiga) {
                fputcsv($file, $singolaRiga,$this->separatore);
            }
            fclose($file);
        }
        
        function rigaSuccessiva() {
            $rigaDaRestituire = $this->rigaCorrente;
            $this->rigaCorrente ++;
            return str_getcsv($this->righeFile[$rigaDaRestituire],$this->separatore);
        }
        
        function raggiuntaFineDelFile() {
            if($this->numeroRighe == $this->rigaCorrente) {
                return true;
            }
            else {
                return false;
            }
        }
        
        function getRigaCorrente() {
            return $this->rigaCorrente;
        }

        function getPercorso() {
            return $this->percorso;
        }

        function getNumeroRighe() {
            return $this->numeroRighe;
        }

        function getNumeroColonne() {
            return $this->numeroColonne;
        }

        function setPercorso($percorso) {
            $this->percorso = $percorso;
            return $this;
        }

        function setNumeroRighe($numeroRighe) {
            $this->numeroRighe = $numeroRighe;
            return $this;
        }

        function setNumeroColonne($numeroColonne) {
            $this->numeroColonne = $numeroColonne;
            return $this;
        }

        function setRigaCorrente($rigaCorrente) {
            $this->rigaCorrente = $rigaCorrente;
            return $this;
        }
    }